<?php if (!defined('VB_ENTRY')) die('Access denied.');

/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * @package vBulletin
 * @subpackage Search
 * @author Kevin Sours, vBulletin Development Team
 * @version $Revision: 28678 $
 * @since $Date: 2008-12-03 16:54:12 +0000 (Wed, 03 Dec 2008) $
 * @copyright Jelsoft Enterprises Ltd.
 */


require_once (DIR . '/vb/search/result.php');

/**
*
*/
class vBForum_Search_Result_Thread extends vB_Search_Result
{
	//for now do not allow creation via the normal way -- group item only
	public static function create($id)
	{
		require_once (DIR . '/vb/legacy/thread.php');
		if ($thread = vB_Legacy_Thread::create_from_id($id))
		{
			$item = new vBForum_Search_Result_Thread();
			$item->thread = $thread;
			return($item);
		}
		//if we get here,  the id must be invalid.
		require_once (DIR . '/vb/search/result/null.php');
		return new vB_Search_Result_Null();
	}

	public static function create_from_thread($thread)
	{
		if ($thread)
		{
			$item = new vBForum_Search_Result_Thread();
			// if we just have an id, we need to create the
			//object
			$item->thread = $thread;
			return $item;
		}
		else
		{
			require_once (DIR . '/vb/search/result/null.php');
			return new vB_Search_Result_Null();
		}
	}

	protected function __construct() {}

	public function get_contenttype()
	{
		return vB_Search_Core::get_instance()->get_contenttypeid('vBForum', 'Thread');
   }

	//we will use the legacy can_search and can_view, for now.
	public function can_search($user)
	{
		return $this->thread->can_search($user);
	}

	public function can_view($user)
	{
		//The user can search if they have one of the following:
		//
		return $this->thread->can_view($user);
	}

	public function render($current_user, $criteria, $template_name = '')
	{
		require_once(DIR . '/includes/functions_forumdisplay.php');
		global $vbulletin;
		global $show;

		if (!strlen($template_name)) {
			$template_name = 'search_threadbit';
		}

		$show['forumlink'] = true;

		// threadbit_deleted conditionals
		$show['threadtitle'] = true;
		$show['viewthread'] = true;
		$show['managethread'] = true;

		//thread isn't a great name for this, but it stays consistant with
		//previous use and what will be expected in the hook.
		$thread = $this->thread->get_record();

		// get info from thread
		$thread['postid'] = $thread['threadid'];
		$thread['threadtitle'] = $thread['title'];
		$thread['threadiconid'] = $thread['iconid'];
		$thread['postdateline'] = $thread['lastpost'];
		$thread['threadtitle'] = $thread['title'];

		$thread['issubscribed'] = $this->thread->is_subscribed($current_user);
		$thread['threadread'] = $this->thread->get_lastread($current_user);

		// if there is a thread preview, truncate it before we display it
		if (isset($thread['preview']) AND $vbulletin->options['threadpreview'] > 0)
		{
			$thread['preview'] = strip_quotes($thread['preview']);
			$thread['preview'] = htmlspecialchars_uni(fetch_trimmed_title(strip_bbcode($thread['preview'], false, true), $vbulletin->options['threadpreview']));
		}

		/*
			This used to be precalculated by forum, but it doesn't look expensive enough to want to
			bother with that.  If that turns out to be wrong we'll need to do some kind of
			caching.
		*/
		$forum = $this->thread->get_forum();
		$lastread = $forum->get_last_read_by_current_user($current_user);

		$show['deletereason'] = false;
		if ($thread['visible'] == 2)
		{
			$log = $this->thread->get_deletion_log_array();
			$thread['del_username'] = $log['username'];
			$thread['del_userid'] = $log['userid'];
			$thread['del_reason'] = $log['reason'];

			$thread['deletedcount']++;
			$show['deletereason'] = !empty($thread['del_reason']);
		}
		else if ($thread['visible'] == 0)
		{
			$thread['hiddencount']++;
		}

		$thread['highlight'] = $criteria->get_highlights();

		$show['moderated'] = ($thread['hiddencount'] > 0 AND
			$current_user->canModerateForum($thread['forumid'], 'canmoderateposts'));

		$show['deletedthread'] = ($thread['deletedcount'] > 0 AND
			($current_user->canModerateForum($thread['forumid']) OR
			$current_user->hasForumPermission($thread['forumid'], 'canseedelnotice')));

		$show['disabled'] = !$this->can_inline_mod($current_user);

		$thread = process_thread_array($thread, $lastread);
		($hook = vBulletinHook::fetch_hook('search_results_threadbit')) ? eval($hook) : false;

		$pageinfo = $pageinfo_lastpost = $pageinfo_firstpost = $pageinfo_lastpage = array();
		if ($show['pagenavmore'])
		{
			$pageinfo_lastpage['page'] = $thread['totalpages'];
		}
		$pageinfo_lastpost['p'] = $thread['lastpostid'];
		$pageinfo_newpost['goto'] = 'newpost';

		$pageinfo_thread = array();
		if (!empty($thread['highlight']))
		{
			$pageinfo_thread['highlight'] = urlencode(implode(' ', $thread['highlight']));
			$pageinfo_newpost['highlight'] = urlencode(implode(' ', $thread['highlight']));
			$pageinfo_lastpost['highlight'] = urlencode(implode(' ', $thread['highlight']));
			$pageinfo_firstpost['highlight'] = urlencode(implode(' ', $thread['highlight']));
		}

		$template = vB_Template::create($template_name);

		$template->register('pageinfo_firstpost', $pageinfo_firstpost);
		$template->register('pageinfo_lastpost', $pageinfo_lastpost);
		$template->register('pageinfo_lastpage', $pageinfo_lastpage);
		$template->register('pageinfo_newpost', $pageinfo_newpost);
		$template->register('pageinfo', $pageinfo_thread);
		$template->register('dateformat', $vbulletin->options['dateformat']);
		$template->register('timeformat', $vbulletin->options['default_timeformat']);
		$template->register('postdateline', $thread['lastpost']);

		$template->register('show', $show);
		$template->register('thread', $thread);

		return $template->render();
	}

	public function get_thread()
	{
		return $this->thread;
	}

	public function set_thread($thread)
	{
		$this->thread = $thread;
	}

	/**
	* Does the user have any inline mod privs for this results item?
	*
	* Might be a candidate to move to the thread object.  Kind of specific
	* to the search right now... depends on which options are in the options
	* list.  The privs don't quite break down the same way on the display
	* end as they are checked on the action end (in inlinemod.php) which is
	* a problem, but I'm not really inclined to try to untangle the checking
	* in inlinemod.
	*/
	private function can_inline_mod($user)
	{
		$forumid = $this->thread->get_field('forumid');
		return (
			$user->canModerateForum($forumid, 'canmanagethreads') OR
			$user->canModerateForum($forumid, 'candeleteposts') OR
			$user->canModerateForum($forumid, 'canremoveposts') OR
			$user->canModerateForum($forumid, 'canmoderateposts') OR
			$user->canModerateForum($forumid, 'canopenclose')
		);
	}

	private $thread;
}


/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 28678 $
|| ####################################################################
\*======================================================================*/